/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.thaumcraft;

import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;

public class RealisticBiomeTCMagicalForest
extends RealisticBiomeBase {
    public RealisticBiomeTCMagicalForest(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainTCMagicalForest();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceTCMagicalForest(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B);
    }

    @Override
    public void initDecos() {
    }

    public static final class SurfaceTCMagicalForest
    extends SurfaceBase {
        private SurfaceTCMagicalForest(BiomeConfig config, IBlockState top, IBlockState filler) {
            super(config, top, filler);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            for (int y = 255; y >= 0; --y) {
                IBlockState bs = primer.func_177856_a(x, y, z);
                if (bs == Blocks.field_150350_a.func_176223_P()) {
                    depth = -1;
                    continue;
                }
                if (bs != Blocks.field_150348_b.func_176223_P()) continue;
                ++depth;
                if (TerrainBase.calcCliff(x, z, noise) > 1.4f) {
                    if (depth > -1 && depth < 2) {
                        if (rtgWorld.rand().nextInt(3) == 0) {
                            primer.func_177855_a(x, y, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, y, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, y, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && y > 61) {
                    primer.func_177855_a(x, y, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, y, z, this.fillerBlock);
            }
        }
    }

    public static final class TerrainTCMagicalForest
    extends TerrainBase {
        private TerrainTCMagicalForest() {
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainTCMagicalForest.terrainForest(x, y, rtgWorld, river, 70.0f);
        }
    }
}

